;coded by UEZ build 2016-01-23
#pragma compile(Icon, "c:\Program Files (x86)\AutoIt3\Icons\au3.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>


_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 600, $iH = 500, $sTitle = "GDI+ Liquid Fountain FX v1.1.1"
AutoItSetOption("GUIOnEventMode", 1)

_Init_GDIPlusEx()
LiquidFountain()

_GDIPlus_Shutdown()


Func LiquidFountain()
	$bExit = False
	$hGUI = GUICreate($sTitle, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
;~ 	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0808080), _
				$hPen_Balls = _GDIPlus_PenCreate(0xF08080F0, 4), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 60, 16)

	Local Const $hFX_BC = _GDIPlus_EffectCreateBrightnessContrast(0, 91), $iBlur = 14, $fBallsSize = 32

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)
	Local $i, $iBalls = 300, $aBallsCoords[$iBalls][6], $iW2 = $iW / 2

	For $i = 0 To $iBalls - 1
		$aBallsCoords[$i][0] = $iW2 - $fBallsSize / 2
		$aBallsCoords[$i][1] = $iH - Random(0, 100)
		$aBallsCoords[$i][2] = Random(-1.25, 1.25)
		$aBallsCoords[$i][3] = Random(-10.5, -2.5)
		$aBallsCoords[$i][4] = _GDIPlus_BrushCreateSolid(0xD0788000 + Random(0xA0, 0xF8, 1))
		$aBallsCoords[$i][5] = 0.125
	Next

	Local $oBitmap = _GDIPlusEx_BitmapCreate($iW, $iH), $a = 0, $b = 0
	_GDIPlus_GraphicsSetSmoothingMode($oBitmap.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBitmap.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Do

		_GDIPlusEx_BitmapClear($oBitmap, 0xE0101010)

		For $i = 0 To $iBalls - 1
			DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $oBitmap.Gfx, "handle", $aBallsCoords[$i][4], _
								   "float", $aBallsCoords[$i][0], "float", $aBallsCoords[$i][1], _
								   "float", $fBallsSize, _
								   "float", $fBallsSize)

;~ 			DllCall($__g_hGDIPDll, "int", "GdipDrawEllipse", "handle", $oBitmap.Gfx, "handle", $hPen_Balls, _
;~ 								   "float", $aBallsCoords[$i][0], "float", $aBallsCoords[$i][1], "float", $fBallsSize, "float", $fBallsSize)
			$aBallsCoords[$i][0] += $aBallsCoords[$i][2]
			$aBallsCoords[$i][1] += $aBallsCoords[$i][3]
			$aBallsCoords[$i][3] += $aBallsCoords[$i][5]
			If $aBallsCoords[$i][1] > $iH Then
				$aBallsCoords[$i][0] = $iW2 - $fBallsSize / 2 + Random(-$fBallsSize, $fBallsSize)
				$aBallsCoords[$i][1] = $iH
				$aBallsCoords[$i][2] = Random(-1.5, 1.5)
				$aBallsCoords[$i][3] = Random(-10, -5)
				$aBallsCoords[$i][5] = 0.125
			EndIf
		Next

		_GDIPlusEx_EffectBlurBitmap($oBitmap, $iBlur)
		_GDIPlus_BitmapApplyEffect($oBitmap.Bmp, $hFX_BC)
		_GDIPlusEx_BitmapDraw($oBuffer, $oBitmap)

		_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw background message text

		_GDIPlusEx_BufferDraw($oBuffer)

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	For $i = 0 To $iBalls - 1
		_GDIPlus_BrushDispose($aBallsCoords[$i][4])
	Next
	_GDIPlus_EffectDispose($hFX_BC)
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_PenDispose($hPen_Balls)
	$oBuffer = Null
	$oBitmap = Null
	GUIDelete($hGUI)
EndFunc   ;==>LiquidFountain


Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS

Func _Init_GDIPlusEx()
	Global Const $_cGDIPEX_ISBMP = 0x41455047
	Global Const $_cGDIPEX_ISBUF = 0x42455047
	Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
	Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
	Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
	Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
	Global $_aGDIPEX_ASMSTRUCT[1]
	OnAutoItExitRegister("__GDIPlusEx_OnExit")
	Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
	Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
	Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
	Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
	Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
	Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
	Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
	Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
	Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
	Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
	Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
	Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
	Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
	Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
	Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
	Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
	Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
			"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
EndFunc   ;==>_Init_GDIPlusEx

Func _GDIPlusEx_BitmapClear($oBitmap, $iColor = 0)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "uint", $iColor)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapClear

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate

Func _GDIPlusEx_BitmapDraw($oBuffer, $oBitmap, $iX = 0, $iY = 0)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 2, False)
	Local $iStatus = $oBitmap.Draw($oBuffer, $iX, $iY)
	If $iStatus Then Return SetError($GDIP_ERRABORTED, 3, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapDraw

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func _GDIPlusEx_EffectBlurBitmap($oBitmap, $iRadius)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	$iRadius = Int($iRadius)
	If $iRadius < 1 Or $iRadius > 127 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tTmp = __GDIPlusEx_BitmapCreate($oBitmap.Width, $oBitmap.Height)
	DllCallAddress("none", $_pGDIPEX_ASM_FXBLUR, "struct*", $tTmp, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "int", $iRadius)
	__GDIPlusEx_BitmapDispose($tTmp)
	Return True
EndFunc   ;==>_GDIPlusEx_EffectBlurBitmap

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit